package com.hero.objects.modifiers;

import org.jdom.Element;

import com.hero.HeroDesigner;
import com.hero.objects.GenericObject;

/**
 * Copyright (c) 2000 - 2005, CompNet Design, Inc. All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, is prohibited unless the following conditions are met: 1.
 * Express written consent of CompNet Design, Inc. is obtained by the developer.
 * 2. Redistributions must retain this copyright notice. THIS SOFTWARE IS
 * PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO
 * EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * @author CompNet Design, Inc.
 * @version $Revision$
 */

public class Nonpersistent extends Modifier {
	private static String xmlID = "NONPERSISTENT";

	public Nonpersistent(Element root) {
		super(root, Nonpersistent.xmlID);
	}

	@Override
	public String included(GenericObject o) {
		String ret = super.included(o);
		if (ret.trim().length() > 0) {
			return ret;
		}

        if (forceAllow()) return ret;
		if (HeroDesigner.getActiveTemplate().is6E()) {
			if ((o.getOrigDuration().equals("PERSISTENT") || o.getOrigDuration().equals("INHERENT")) && o.getEndUsage() == 0) {
				return "";
			} else {
				if (findObjectByID(o.getAssignedModifiers(), "COSTSENDTOMAINTAIN") != null) {
					return "";
				} else {
					return getDisplay()
					+ " can only be applied to abilities which are Persistent.";
				}
			}
		} else {
			if (o.getOrigDuration().equals("PERSISTENT") && o.getEndUsage() == 0) { // &&
															// (o.getEndUsage()
															// == 0)) {
				return "";
			} else if (o.getDuration().equals("PERSISTENT")) {
				if (HeroDesigner.getActiveTemplate().is6E()) {
					if (findObjectByID(o.getAssignedModifiers(),
							"COSTSENDONLYTOACTIVATE") != null) {
						return "";
					} else if (findObjectByID(o.getAssignedModifiers(),
							"COSTSEND") != null) {
						GenericObject go = findObjectByID(o
								.getAssignedModifiers(), "COSTSEND");
						if (go.getSelectedOption() != null
								&& go.getSelectedOption().getXMLID().equals(
										"ACTIVATE")) {
							return "";
						} else {
							return getDisplay()
									+ " can only be applied to abilities which are Persistent.";
						}
					} else {
						return getDisplay()
								+ " can only be applied to abilities which are Persistent.";
					}
				} else {
					return getDisplay()
							+ " can only be applied to abilities which are Persistent.";
				}
			} else {
				return getDisplay()
						+ " can only be applied to abilities which are Persistent.";
			}
		}
	}
}